//
// 	NetFilterSDK 
// 	Copyright (C) Vitaly Sidorov
//	All rights reserved.
//
//	This file is a part of the NetFilter SDK.
//	The code and information is provided "as-is" without
//	warranty of any kind, either expressed or implied.
//

#include "vdefs.h"
#include "vthread.h"

using namespace mainNS;

#ifdef WIN32

#include <process.h>

vthread_t mainNS::vthread_create(VTHREAD_START start_routine, void *arg)
{
	vthread_t t;
	
	t = (HANDLE)_beginthreadex(0, 0, start_routine, arg, 0, NULL);
	if (t == (HANDLE)(-1L))
	{
		return NULL;
	}
	
	return t;
}

void mainNS::vthread_wait(vthread_t b)
{
	if (!b)
		return;
    WaitForSingleObject(b, INFINITE);
    CloseHandle(b);
}

#else

vthread_t mainNS::vthread_create(VTHREAD_START start_routine, void *arg)
{
	vthread_t t;
	
	if (pthread_create(&t, NULL, start_routine, arg) != 0)
	{
		return 0;
	}

	return t;
}

void mainNS::vthread_wait(vthread_t b)
{
	if (!b)
		return;
	
	pthread_join(b, NULL);
}

#endif