//
// 	NetFilterSDK 
// 	Copyright (C) Vitaly Sidorov
//	All rights reserved.
//
//	This file is a part of the NetFilter SDK.
//	The code and information is provided "as-is" without
//	warranty of any kind, either expressed or implied.
//

#pragma once

#include "vdefs.h"

namespace mainNS
{
	enum _VCS_FLAGS
	{
		VF_STATIC,
		VF_DYNAMIC
	};

	typedef struct _VCS
	{
#ifdef WIN32
		CRITICAL_SECTION cs;
#else
		pthread_mutex_t cs;
#endif
		int     flags;
	} VCS, *PVCS;

	typedef VCS * vcs_t;

	vcs_t vcs_create();
	bool vcs_init(vcs_t b);
	void vcs_free(vcs_t b);

	void vcs_lock(vcs_t b);
	void vcs_unlock(vcs_t b);

	class AutoVCS
	{
	public:
		AutoVCS(vcs_t b) : m_b(b)
		{
			vcs_lock(b);
		}
		~AutoVCS()
		{
			vcs_unlock(m_b);
		}
	private:
		vcs_t m_b;
	};

	typedef struct _SYNC_EVENT
	{
#ifdef WIN32
		HANDLE  event;
#else
		pthread_cond_t	event;
#endif 		
		int     flags;
		vcs_t	cs;
	} SYNC_EVENT, *PSYNC_EVENT;

	typedef _SYNC_EVENT * vsyncEvent_t;

	vsyncEvent_t vsyncEvent_create();
	BOOL vsyncEvent_fire(vsyncEvent_t b, int flags);
	BOOL vsyncEvent_fireAll(vsyncEvent_t b, int flags);
	BOOL vsyncEvent_wait(vsyncEvent_t b, int * pFlags);
	BOOL vsyncEvent_wait(vsyncEvent_t b, int * pFlags, unsigned int timeout);
	BOOL vsyncEvent_isFlagFired(vsyncEvent_t b, int flag);
	void vsyncEvent_free(vsyncEvent_t b);

}