//
// 	NetFilterSDK 
// 	Copyright (C) Vitaly Sidorov
//	All rights reserved.
//
//	This file is a part of the NetFilter SDK.
//	The code and information is provided "as-is" without
//	warranty of any kind, either expressed or implied.
//

#pragma once

typedef struct _VLIST_ENTRY
{
    struct _VLIST_ENTRY * Flink;
    struct _VLIST_ENTRY * Blink;
} VLIST_ENTRY, * PVLIST_ENTRY;

#define vlist_record(address, type, field) \
    ((type *)((char*)(address) - (char*)(&((type *)0)->field)))

#define vlist_init(listHead) (\
    (listHead)->Flink = (listHead)->Blink = (listHead))

#define vlist_isEmpty(listHead) \
    ((listHead)->Flink == (listHead))

#define vlist_move(listDst, listSrc) { \
	(listDst)->Flink = (listSrc)->Flink; \
	(listDst)->Flink->Blink = (listDst); \
	(listDst)->Blink = (listSrc)->Blink; \
	(listDst)->Blink->Flink = (listDst); \
	vlist_init(listSrc); \
	}

#define vlist_getHead(listHead) \
    (listHead)->Flink

#define vlist_getTail(listHead) \
    (listHead)->Blink

#define vlist_removeHead(listHead) \
    (listHead)->Flink;\
    {vlist_removeEntry((listHead)->Flink)}

#define vlist_removeTail(listHead) \
    (listHead)->Blink;\
    {vlist_removeEntry((listHead)->Blink)}

#define vlist_removeEntry(entry) {\
    PVLIST_ENTRY _EX_Blink;\
    PVLIST_ENTRY _EX_Flink;\
    _EX_Flink = (entry)->Flink;\
    _EX_Blink = (entry)->Blink;\
    _EX_Blink->Flink = _EX_Flink;\
    _EX_Flink->Blink = _EX_Blink;\
    }

#define vlist_insertTail(listHead, entry) {\
    PVLIST_ENTRY _EX_Blink;\
    PVLIST_ENTRY _EX_ListHead;\
    PVLIST_ENTRY e = (entry); \
    if (e) { \
    _EX_ListHead = (listHead);\
    _EX_Blink = _EX_ListHead->Blink;\
    e->Flink = _EX_ListHead;\
    e->Blink = _EX_Blink;\
    _EX_Blink->Flink = e;\
    _EX_ListHead->Blink = e;\
    } \
    }

#define vlist_insertHead(listHead, entry) {\
    PVLIST_ENTRY _EX_Flink;\
    PVLIST_ENTRY _EX_ListHead;\
    PVLIST_ENTRY e = (entry); \
    if (e) { \
    _EX_ListHead = (listHead);\
    _EX_Flink = _EX_ListHead->Flink;\
    e->Flink = _EX_Flink;\
    e->Blink = _EX_ListHead;\
    _EX_Flink->Blink = e;\
    _EX_ListHead->Flink = e;\
    } \
    }

#define vlist_forEach(listHead, entry) \
    for (entry = vlist_getHead(listHead); \
        entry != listHead; \
        entry = vlist_getHead(entry))

